/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.PlanSTMoc;
import cds.aladin.Position;
import cds.aladin.Source;
import cds.aladin.SourceFootprint;
import cds.aladin.stc.STCObj;
import cds.moc.Healpix;
import cds.moc.Range2;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.tools.Util;
import java.util.Iterator;
import java.util.List;

public class PlanSTMocGen
extends PlanSTMoc {
    private Plan[] p;
    private double duration;
    private double radius;
    private boolean fov;
    private int timeOrder = 14;
    private int spaceOrder = 10;
    private boolean flagOneRange = false;
    private double gapPourcent;
    private boolean stop;

    protected PlanSTMocGen(Aladin aladin, String label, Plan[] p, int spaceOrder, int timeOrder, double duration, double radius, boolean fov) {
        super(aladin, (MyInputStream)null, label, null, 0.0, null);
        Aladin.trace(3, "STMOC creation: " + Plan.Tp[this.type]);
        this.c = null;
        this.p = p;
        this.label = label;
        this.spaceOrder = spaceOrder;
        this.timeOrder = timeOrder;
        this.duration = duration;
        this.radius = radius;
        this.fov = fov;
        this.pourcent = 0.0;
        this.gapPourcent = 100 / p.length;
        this.suiteSpecific();
        this.threading();
        this.log();
    }

    @Override
    protected void launchLoading() {
    }

    protected PlanSTMocGen(Aladin aladin, String label, Plan[] pList, int spaceOrder, int timeOrder, double jdmin, double jdmax) {
        super(aladin);
        PlanMoc p1 = (PlanMoc)pList[0];
        p1.copy(this);
        this.type = 24;
        this.setLabel(label == null ? "[" + this.label + "]" : label);
        this.c = Couleur.getNextDefault(aladin.calque);
        SMoc m1 = null;
        try {
            m1 = (SMoc)p1.getMoc().clone();
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
        for (int i = 1; i < pList.length; ++i) {
            SMoc m2 = (SMoc)((PlanMoc)pList[i]).getMoc();
            try {
                m1 = m1.union(m2);
                continue;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
        Range2 r = new Range2();
        long min = (long)(jdmin * 8.64E10);
        long max = (long)(jdmax * 8.64E10) + 1L;
        r.append(min, max, m1.seeRangeList());
        try {
            this.moc = new STMoc(timeOrder < 0 ? 61 : timeOrder, spaceOrder < 0 ? m1.getMocOrder() : spaceOrder);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.moc.setRangeList(r);
        this.flagOneRange = true;
    }

    @Override
    protected boolean isOneTimeRange() {
        return this.flagOneRange && ((STMoc)this.moc).range.nranges() == 1;
    }

    @Override
    protected boolean Free() {
        this.stop = true;
        return super.Free();
    }

    private void addMocFromCatalog(Plan p1, double duration, double radius, boolean fov) throws Exception {
        long t0;
        int m;
        block13: {
            this.stop = false;
            SMoc m1 = null;
            STMoc m2 = new STMoc(this.timeOrder, this.spaceOrder);
            Iterator<Obj> it = p1.iterator();
            Healpix hpx = new Healpix();
            double incrPourcent = this.gapPourcent / (double)p1.getCounts();
            m = 0;
            t0 = System.currentTimeMillis();
            while (it.hasNext()) {
                double jdtime;
                Obj o = it.next();
                if (!(o instanceof Position)) continue;
                this.pourcent += incrPourcent;
                if (++m % 10000 == 0) {
                    block12: {
                        if (this.stop) {
                            throw new Exception("Abort");
                        }
                        try {
                            this.moc = this.moc.union(m2);
                        }
                        catch (Exception e) {
                            if (Aladin.levelTrace < 3) break block12;
                            e.printStackTrace();
                        }
                    }
                    m2.clear();
                }
                if (Double.isNaN(jdtime = ((Position)o).jdtime)) continue;
                double jdend = jdtime + duration / 86400.0;
                try {
                    if (!fov && radius == 0.0) {
                        long npix = hpx.ang2pix(this.spaceOrder, ((Position)o).raj, ((Position)o).dej);
                        m2.add(this.spaceOrder, npix, jdtime, jdend);
                        continue;
                    }
                    m1 = null;
                    if (fov) {
                        List<STCObj> listStcs;
                        Source s = (Source)o;
                        SourceFootprint sf = s.getFootprint();
                        if (sf == null || (listStcs = sf.getStcObjects()) == null) continue;
                        m1 = Aladin.createMocRegion(listStcs, this.spaceOrder, true);
                    } else {
                        m1 = Aladin.createMocRegionCircle(((Position)o).raj, ((Position)o).dej, radius, this.spaceOrder, true);
                    }
                    m2.add(jdtime, jdend, m1);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
            try {
                this.moc = this.moc.union(m2);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block13;
                e.printStackTrace();
            }
        }
        long t1 = System.currentTimeMillis();
        Aladin.trace(4, "STMOC build in " + Util.getTemps((t1 - t0) * 1000L) + " nbSrc=" + m);
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.moc = new STMoc(this.timeOrder, this.spaceOrder);
            for (Plan p1 : this.p) {
                if (!p1.isCatalogTime()) continue;
                if (this.c == null) {
                    this.c = p1.c.darker();
                }
                this.addMocFromCatalog(p1, this.duration, this.radius, this.fov);
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.flagProcessing = false;
            return false;
        }
        this.flagProcessing = false;
        this.flagOk = true;
        this.aladin.calque.repaintAll();
        return true;
    }
}

